/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.PskKeyExchangeModesExtension;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLExtensions;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLProducer;
import sun.security.ssl.SSLSecretDerivation;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SessionId;
import sun.security.ssl.Utilities;

final class NewSessionTicket {
    private static final int MAX_TICKET_LIFETIME = 604800;
    static final SSLConsumer handshakeConsumer = new NewSessionTicketConsumer();
    static final SSLProducer kickstartProducer = new NewSessionTicketKickstartProducer();
    static final HandshakeProducer handshakeProducer = new NewSessionTicketProducer();

    NewSessionTicket() {
    }

    private static SecretKey derivePreSharedKey(CipherSuite.HashAlg hashAlg, SecretKey secretKey, byte[] byArray) throws IOException {
        try {
            HKDF hKDF = new HKDF(hashAlg.name);
            byte[] byArray2 = SSLSecretDerivation.createHkdfInfo("tls13 resumption".getBytes(), byArray, hashAlg.hashLength);
            return hKDF.expand(secretKey, byArray2, hashAlg.hashLength, "TlsPreSharedKey");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not derive PSK").initCause(generalSecurityException);
        }
    }

    private static final class NewSessionTicketConsumer
    implements SSLConsumer {
        private NewSessionTicketConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            NewSessionTicketMessage newSessionTicketMessage = new NewSessionTicketMessage(handshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming NewSessionTicket message", newSessionTicketMessage);
            }
            if (newSessionTicketMessage.ticketLifetime <= 0 || newSessionTicketMessage.ticketLifetime > 604800) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Discarding NewSessionTicket with lifetime " + newSessionTicketMessage.ticketLifetime, newSessionTicketMessage);
                }
                return;
            }
            SSLSessionContextImpl sSLSessionContextImpl = (SSLSessionContextImpl)handshakeContext.sslContext.engineGetClientSessionContext();
            if (sSLSessionContextImpl.getSessionTimeout() > 604800) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Session cache lifetime is too long. Discarding ticket.", new Object[0]);
                }
                return;
            }
            SSLSessionImpl sSLSessionImpl = handshakeContext.conContext.conSession;
            SecretKey secretKey = sSLSessionImpl.getResumptionMasterSecret();
            if (secretKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Session has no resumption master secret. Ignoring ticket.", new Object[0]);
                }
                return;
            }
            SecretKey secretKey2 = NewSessionTicket.derivePreSharedKey(sSLSessionImpl.getSuite().hashAlg, secretKey, newSessionTicketMessage.ticketNonce);
            SessionId sessionId = new SessionId(true, handshakeContext.sslContext.getSecureRandom());
            SSLSessionImpl sSLSessionImpl2 = new SSLSessionImpl(sSLSessionImpl, sessionId);
            sSLSessionImpl.addChild(sSLSessionImpl2);
            sSLSessionImpl2.setPreSharedKey(secretKey2);
            sSLSessionImpl2.setTicketAgeAdd(newSessionTicketMessage.ticketAgeAdd);
            sSLSessionImpl2.setPskIdentity(newSessionTicketMessage.ticket);
            sSLSessionContextImpl.put(sSLSessionImpl2);
            handshakeContext.conContext.finishPostHandshake();
        }
    }

    private static final class NewSessionTicketProducer
    implements HandshakeProducer {
        private NewSessionTicketProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            throw new ProviderException("NewSessionTicket handshake producer not implemented");
        }
    }

    private static final class NewSessionTicketKickstartProducer
    implements SSLProducer {
        private NewSessionTicketKickstartProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.handshakeSession.isRejoinable()) {
                return null;
            }
            PskKeyExchangeModesExtension.PskKeyExchangeModesSpec pskKeyExchangeModesSpec = (PskKeyExchangeModesExtension.PskKeyExchangeModesSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.PSK_KEY_EXCHANGE_MODES);
            if (pskKeyExchangeModesSpec == null || !pskKeyExchangeModesSpec.contains(PskKeyExchangeModesExtension.PskKeyExchangeMode.PSK_DHE_KE)) {
                return null;
            }
            SSLSessionContextImpl sSLSessionContextImpl = (SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext();
            SessionId sessionId = new SessionId(true, serverHandshakeContext.sslContext.getSecureRandom());
            SecretKey secretKey = serverHandshakeContext.handshakeSession.getResumptionMasterSecret();
            if (secretKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Session has no resumption secret. No ticket sent.", new Object[0]);
                }
                return null;
            }
            BigInteger bigInteger = serverHandshakeContext.handshakeSession.incrTicketNonceCounter();
            byte[] byArray = bigInteger.toByteArray();
            SecretKey secretKey2 = NewSessionTicket.derivePreSharedKey(serverHandshakeContext.negotiatedCipherSuite.hashAlg, secretKey, byArray);
            int n = sSLSessionContextImpl.getSessionTimeout();
            if (n > 604800) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Session timeout is too long. No ticket sent.", new Object[0]);
                }
                return null;
            }
            NewSessionTicketMessage newSessionTicketMessage = new NewSessionTicketMessage(serverHandshakeContext, n, serverHandshakeContext.sslContext.getSecureRandom(), byArray, sessionId.getId());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced NewSessionTicket handshake message", newSessionTicketMessage);
            }
            SSLSessionImpl sSLSessionImpl = new SSLSessionImpl(serverHandshakeContext.handshakeSession, sessionId);
            serverHandshakeContext.handshakeSession.addChild(sSLSessionImpl);
            sSLSessionImpl.setPreSharedKey(secretKey2);
            sSLSessionImpl.setPskIdentity(sessionId.getId());
            sSLSessionImpl.setTicketAgeAdd(newSessionTicketMessage.ticketAgeAdd);
            sSLSessionContextImpl.put(sSLSessionImpl);
            newSessionTicketMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class NewSessionTicketMessage
    extends SSLHandshake.HandshakeMessage {
        final int ticketLifetime;
        final int ticketAgeAdd;
        final byte[] ticketNonce;
        final byte[] ticket;
        final SSLExtensions extensions;

        NewSessionTicketMessage(HandshakeContext handshakeContext, int n, SecureRandom secureRandom, byte[] byArray, byte[] byArray2) {
            super(handshakeContext);
            this.ticketLifetime = n;
            this.ticketAgeAdd = secureRandom.nextInt();
            this.ticketNonce = byArray;
            this.ticket = byArray2;
            this.extensions = new SSLExtensions(this);
        }

        NewSessionTicketMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 14) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid NewSessionTicket message: no sufficient data");
            }
            this.ticketLifetime = Record.getInt32(byteBuffer);
            this.ticketAgeAdd = Record.getInt32(byteBuffer);
            this.ticketNonce = Record.getBytes8(byteBuffer);
            if (byteBuffer.remaining() < 5) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid NewSessionTicket message: no sufficient data");
            }
            this.ticket = Record.getBytes16(byteBuffer);
            if (this.ticket.length == 0) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ticket in the NewSessionTicket handshake message");
            }
            if (byteBuffer.remaining() < 2) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid NewSessionTicket message: no sufficient data");
            }
            SSLExtension[] sSLExtensionArray = handshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.NEW_SESSION_TICKET);
            this.extensions = new SSLExtensions(this, byteBuffer, sSLExtensionArray);
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.NEW_SESSION_TICKET;
        }

        @Override
        public int messageLength() {
            int n = this.extensions.length();
            if (n == 0) {
                n = 2;
            }
            return 8 + this.ticketNonce.length + 1 + this.ticket.length + 2 + n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt32(this.ticketLifetime);
            handshakeOutStream.putInt32(this.ticketAgeAdd);
            handshakeOutStream.putBytes8(this.ticketNonce);
            handshakeOutStream.putBytes16(this.ticket);
            if (this.extensions.length() == 0) {
                handshakeOutStream.putInt16(0);
            } else {
                this.extensions.send(handshakeOutStream);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"NewSessionTicket\": '{'\n  \"ticket_lifetime\"      : \"{0}\",\n  \"ticket_age_add\"       : \"{1}\",\n  \"ticket_nonce\"         : \"{2}\",\n  \"ticket\"               : \"{3}\",\n  \"extensions\"           : [\n{4}\n  ]\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{this.ticketLifetime, "<omitted>", Utilities.toHexString(this.ticketNonce), Utilities.toHexString(this.ticket), Utilities.indent(this.extensions.toString(), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

