/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ClientHello;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.HelloCookieManager;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.ServerHello;
import sun.security.ssl.Utilities;

public class CookieExtension {
    static final HandshakeProducer chNetworkProducer = new CHCookieProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHCookieConsumer();
    static final HandshakeConsumer chOnTradeConsumer = new CHCookieUpdate();
    static final HandshakeProducer hrrNetworkProducer = new HRRCookieProducer();
    static final SSLExtension.ExtensionConsumer hrrOnLoadConsumer = new HRRCookieConsumer();
    static final HandshakeProducer hrrNetworkReproducer = new HRRCookieReproducer();
    static final CookieStringizer cookieStringizer = new CookieStringizer();

    private static final class HRRCookieReproducer
    implements HandshakeProducer {
        private HRRCookieReproducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_COOKIE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable cookie extension", new Object[0]);
                }
                return null;
            }
            CookieSpec cookieSpec = (CookieSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_COOKIE);
            if (cookieSpec != null && cookieSpec.cookie != null && cookieSpec.cookie.length != 0) {
                byte[] byArray = new byte[cookieSpec.cookie.length + 2];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                Record.putBytes16(byteBuffer, cookieSpec.cookie);
                return byArray;
            }
            return null;
        }
    }

    private static final class HRRCookieConsumer
    implements SSLExtension.ExtensionConsumer {
        private HRRCookieConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CookieSpec cookieSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_COOKIE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable cookie extension", new Object[0]);
                }
                return;
            }
            try {
                cookieSpec = new CookieSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.HRR_COOKIE, cookieSpec);
        }
    }

    private static final class HRRCookieProducer
    implements HandshakeProducer {
        private HRRCookieProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ServerHello.ServerHelloMessage serverHelloMessage = (ServerHello.ServerHelloMessage)handshakeMessage;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_COOKIE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable cookie extension", new Object[0]);
                }
                return null;
            }
            HelloCookieManager helloCookieManager = serverHandshakeContext.sslContext.getHelloCookieManager(serverHandshakeContext.negotiatedProtocol);
            byte[] byArray = helloCookieManager.createCookie(serverHandshakeContext, serverHelloMessage.clientHello);
            byte[] byArray2 = new byte[byArray.length + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            Record.putBytes16(byteBuffer, byArray);
            return byArray2;
        }
    }

    private static final class CHCookieUpdate
    implements HandshakeConsumer {
        private CHCookieUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            CookieSpec cookieSpec = (CookieSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_COOKIE);
            if (cookieSpec == null) {
                return;
            }
            HelloCookieManager helloCookieManager = serverHandshakeContext.sslContext.getHelloCookieManager(serverHandshakeContext.negotiatedProtocol);
            if (!helloCookieManager.isCookieValid(serverHandshakeContext, clientHelloMessage, cookieSpec.cookie)) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "unrecognized cookie");
                return;
            }
        }
    }

    private static final class CHCookieConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHCookieConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CookieSpec cookieSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_COOKIE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable cookie extension", new Object[0]);
                }
                return;
            }
            try {
                cookieSpec = new CookieSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_COOKIE, cookieSpec);
        }
    }

    private static final class CHCookieProducer
    implements HandshakeProducer {
        private CHCookieProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_COOKIE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable cookie extension", new Object[0]);
                }
                return null;
            }
            CookieSpec cookieSpec = (CookieSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.HRR_COOKIE);
            if (cookieSpec != null && cookieSpec.cookie != null && cookieSpec.cookie.length != 0) {
                byte[] byArray = new byte[cookieSpec.cookie.length + 2];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                Record.putBytes16(byteBuffer, cookieSpec.cookie);
                return byArray;
            }
            return null;
        }
    }

    private static final class CookieStringizer
    implements SSLStringizer {
        private CookieStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CookieSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static class CookieSpec
    implements SSLExtension.SSLExtensionSpec {
        final byte[] cookie;

        private CookieSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 3) {
                throw new SSLProtocolException("Invalid cookie extension: insufficient data");
            }
            this.cookie = Record.getBytes16(byteBuffer);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"cookie\": '{'\n{0}\n'}',", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encode(this.cookie))};
            return messageFormat.format(objectArray);
        }
    }
}

