/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.TransportContext;

enum Alert {
    CLOSE_NOTIFY(0, "close_notify", false),
    UNEXPECTED_MESSAGE(10, "unexpected_message", false),
    BAD_RECORD_MAC(20, "bad_record_mac", false),
    DECRYPTION_FAILED(21, "decryption_failed", false),
    RECORD_OVERFLOW(22, "record_overflow", false),
    DECOMPRESSION_FAILURE(30, "decompression_failure", false),
    HANDSHAKE_FAILURE(40, "handshake_failure", true),
    NO_CERTIFICATE(41, "no_certificate", true),
    BAD_CERTIFICATE(42, "bad_certificate", true),
    UNSUPPORTED_CERTIFICATE(43, "unsupported_certificate", true),
    CERTIFICATE_REVOKED(44, "certificate_revoked", true),
    CERTIFICATE_EXPIRED(45, "certificate_expired", true),
    CERTIFICATE_UNKNOWN(46, "certificate_unknown", true),
    ILLEGAL_PARAMETER(47, "illegal_parameter", true),
    UNKNOWN_CA(48, "unknown_ca", true),
    ACCESS_DENIED(49, "access_denied", true),
    DECODE_ERROR(50, "decode_error", true),
    DECRYPT_ERROR(51, "decrypt_error", true),
    EXPORT_RESTRICTION(60, "export_restriction", true),
    PROTOCOL_VERSION(70, "protocol_version", true),
    INSUFFICIENT_SECURITY(71, "insufficient_security", true),
    INTERNAL_ERROR(80, "internal_error", false),
    INAPPROPRIATE_FALLBACK(86, "inappropriate_fallback", false),
    USER_CANCELED(90, "user_canceled", false),
    NO_RENEGOTIATION(100, "no_renegotiation", true),
    MISSING_EXTENSION(109, "missing_extension", true),
    UNSUPPORTED_EXTENSION(110, "unsupported_extension", true),
    CERT_UNOBTAINABLE(111, "certificate_unobtainable", true),
    UNRECOGNIZED_NAME(112, "unrecognized_name", true),
    BAD_CERT_STATUS_RESPONSE(113, "bad_certificate_status_response", true),
    BAD_CERT_HASH_VALUE(114, "bad_certificate_hash_value", true),
    UNKNOWN_PSK_IDENTITY(115, "unknown_psk_identity", true),
    CERTIFICATE_REQUIRED(116, "certificate_required", true),
    NO_APPLICATION_PROTOCOL(120, "no_application_protocol", true);

    final byte id;
    final String description;
    final boolean handshakeOnly;
    static final SSLConsumer alertConsumer;

    private Alert(byte by, String string2, boolean bl) {
        this.id = by;
        this.description = string2;
        this.handshakeOnly = bl;
    }

    static Alert valueOf(byte by) {
        for (Alert alert : Alert.values()) {
            if (alert.id != by) continue;
            return alert;
        }
        return null;
    }

    static String nameOf(byte by) {
        for (Alert alert : Alert.values()) {
            if (alert.id != by) continue;
            return alert.description;
        }
        return "UNKNOWN ALERT (" + (by & 0xFF) + ")";
    }

    SSLException createSSLException(String string) {
        return this.createSSLException(string, null);
    }

    SSLException createSSLException(String string, Throwable throwable) {
        if (string == null) {
            String string2 = string = throwable != null ? throwable.getMessage() : "";
        }
        SSLException sSLException = throwable != null && throwable instanceof IOException ? new SSLException(string) : (this == UNEXPECTED_MESSAGE ? new SSLProtocolException(string) : (this.handshakeOnly ? new SSLHandshakeException(string) : new SSLException(string)));
        if (throwable != null) {
            sSLException.initCause(throwable);
        }
        return sSLException;
    }

    static {
        alertConsumer = new AlertConsumer();
    }

    private static final class AlertConsumer
    implements SSLConsumer {
        private AlertConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            TransportContext transportContext = (TransportContext)connectionContext;
            AlertMessage alertMessage = new AlertMessage(transportContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("Received alert message", alertMessage);
            }
            Level level = Level.valueOf(alertMessage.level);
            Alert alert = Alert.valueOf(alertMessage.id);
            if (alert == CLOSE_NOTIFY) {
                transportContext.isInputCloseNotified = true;
                transportContext.closeInbound();
                if (transportContext.peerUserCanceled) {
                    transportContext.closeOutbound();
                } else if (transportContext.handshakeContext != null) {
                    transportContext.fatal(UNEXPECTED_MESSAGE, "Received close_notify during handshake");
                }
            } else if (alert == USER_CANCELED) {
                if (level == Level.WARNING) {
                    transportContext.peerUserCanceled = true;
                } else {
                    transportContext.fatal(alert, "Received fatal close_notify alert", true, null);
                }
            } else if (level == Level.WARNING && alert != null) {
                if (alert.handshakeOnly && transportContext.handshakeContext != null) {
                    if (transportContext.sslConfig.isClientMode || alert != NO_CERTIFICATE || transportContext.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_REQUESTED) {
                        transportContext.fatal(HANDSHAKE_FAILURE, "received handshake warning: " + alert.description);
                    } else {
                        transportContext.handshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE.id);
                        transportContext.handshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
                    }
                }
            } else {
                String string;
                if (alert == null) {
                    alert = UNEXPECTED_MESSAGE;
                    string = "Unknown alert description (" + alertMessage.id + ")";
                } else {
                    string = "Received fatal alert: " + alert.description;
                }
                transportContext.fatal(alert, string, true, null);
            }
        }
    }

    private static final class AlertMessage {
        private final byte level;
        private final byte id;

        AlertMessage(TransportContext transportContext, ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() != 2) {
                transportContext.fatal(ILLEGAL_PARAMETER, "Invalid Alert message: no sufficient data");
            }
            this.level = byteBuffer.get();
            this.id = byteBuffer.get();
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"Alert\": '{'\n  \"level\"      : \"{0}\",\n  \"description\": \"{1}\"\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{Level.nameOf(this.level), Alert.nameOf(this.id)};
            return messageFormat.format(objectArray);
        }
    }

    static enum Level {
        WARNING(1, "warning"),
        FATAL(2, "fatal");

        final byte level;
        final String description;

        private Level(byte by, String string2) {
            this.level = by;
            this.description = string2;
        }

        static Level valueOf(byte by) {
            for (Level level : Level.values()) {
                if (level.level != by) continue;
                return level;
            }
            return null;
        }

        static String nameOf(byte by) {
            for (Level level : Level.values()) {
                if (level.level != by) continue;
                return level.description;
            }
            return "UNKNOWN ALERT LEVEL (" + (by & 0xFF) + ")";
        }
    }
}

