/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.uareu;

import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.UareUException;

public interface Reader {
    public void Open(Priority var1) throws UareUException;

    public void Close() throws UareUException;

    public Status GetStatus() throws UareUException;

    public Capabilities GetCapabilities();

    public Description GetDescription();

    public CaptureResult Capture(Fid.Format var1, ImageProcessing var2, int var3, int var4) throws UareUException;

    public void CancelCapture() throws UareUException;

    public void StartStreaming() throws UareUException;

    public void StopStreaming() throws UareUException;

    public CaptureResult GetStreamImage(Fid.Format var1, ImageProcessing var2, int var3) throws UareUException;

    public void Calibrate() throws UareUException;

    public void Reset() throws UareUException;

    public static enum Priority {
        COOPERATIVE,
        EXCLUSIVE;

    }

    public static enum ImageProcessing {
        IMG_PROC_DEFAULT,
        IMG_PROC_PIV,
        IMG_PROC_ENHANCED,
        IMG_PROC_UNPROCESSED;

    }

    public static class Status {
        public boolean finger_detected;
        public ReaderStatus status;
        public byte[] vendor_data;
    }

    public static enum ReaderStatus {
        READY,
        BUSY,
        NEED_CALIBRATION,
        FAILURE;

    }

    public static class CaptureResult {
        public int score;
        public CaptureQuality quality;
        public Fid image;
    }

    public static enum CaptureQuality {
        GOOD,
        TIMED_OUT,
        CANCELED,
        NO_FINGER,
        FAKE_FINGER,
        FINGER_TOO_LEFT,
        FINGER_TOO_RIGHT,
        FINGER_TOO_HIGH,
        FINGER_TOO_LOW,
        FINGER_OFF_CENTER,
        SCAN_SKEWED,
        SCAN_TOO_SHORT,
        SCAN_TOO_LONG,
        SCAN_TOO_SLOW,
        SCAN_TOO_FAST,
        SCAN_WRONG_DIRECTION,
        READER_DIRTY;

    }

    public static class Capabilities {
        public boolean can_capture;
        public boolean can_stream;
        public boolean can_extract_features;
        public boolean can_match;
        public boolean can_identify;
        public boolean has_fingerprint_storage;
        public int indicator_type;
        public boolean has_power_management;
        public boolean has_calibration;
        public boolean piv_compliant;
        public int[] resolutions;
    }

    public static class Description {
        public String name;
        public String serial_number;
        public Id id = new Id();
        public Modality modality = Modality.HW_MODALITY_UNKNOWN;
        public Technology technology = Technology.HW_TECHNOLOGY_UNKNOWN;
        public Version version = new Version();
    }

    public static enum Technology {
        HW_TECHNOLOGY_UNKNOWN,
        HW_TECHNOLOGY_OPTICAL,
        HW_TECHNOLOGY_CAPACITIVE,
        HW_TECHNOLOGY_THERMAL,
        HW_TECHNOLOGY_PRESSURE;

    }

    public static enum Modality {
        HW_MODALITY_UNKNOWN,
        HW_MODALITY_SWIPE,
        HW_MODALITY_AREA;

    }

    public static class Version {
        public VersionInfo firmware_version = new VersionInfo();
        public VersionInfo hardware_version = new VersionInfo();
        public int bcd_revision;
    }

    public static class VersionInfo {
        public int major;
        public int minor;
        public int maintenance;
    }

    public static class Id {
        public int product_id;
        public int vendor_id;
        public String product_name;
        public String vendor_name;
    }
}

