/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final TypeConverter converter;
    private final Object object;
    private final Class<?> type;

    public ObjectValueExpression(TypeConverter converter, Object object, Class<?> type) {
        this.converter = converter;
        this.object = object;
        this.type = type;
        if (type == null) {
            throw new NullPointerException(LocalMessages.get("error.value.notype", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            ObjectValueExpression other = (ObjectValueExpression)obj;
            if (this.type != other.type) {
                return false;
            }
            return this.object == other.object || this.object != null && this.object.equals(other.object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.object == null ? 0 : this.object.hashCode();
    }

    @Override
    public Object getValue(ELContext context) {
        return this.converter.convert(this.object, this.type);
    }

    @Override
    public String getExpressionString() {
        return null;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Class<?> getType(ELContext context) {
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context) {
        return true;
    }

    @Override
    public void setValue(ELContext context, Object value) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", new Object[0]));
    }

    public String toString() {
        return "ValueExpression(" + this.object + ")";
    }

    @Override
    public Class<?> getExpectedType() {
        return this.type;
    }
}

