/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSGlassPane;
import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.WindowContainer;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.basic.BasicInternalFrameUI;

class OSScreenLock
extends JDialog
implements SubWindow,
WindowListener {
    private OSGlassPane glasspane = new OSGlassPane();
    private ContentPaneImpl contentpane;
    private ViewContext viewContext;
    private OSView osview;
    private ImageIcon frameIcon;

    public OSScreenLock() {
        this.setGlassPane(this.glasspane);
        this.contentpane = new ContentPaneImpl();
        this.setContentPane(this.contentpane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    void showGlassPane() {
        this.glasspane.setVisible(true);
    }

    void hideGlassPane() {
        this.glasspane.setVisible(false);
    }

    void setContent(Component comp) {
        this.glasspane.removeAll();
        if (comp != null) {
            this.glasspane.add(this.createComponentHolder(comp));
            if (comp instanceof ViewContext) {
                this.viewContext = (ViewContext)((Object)comp);
            }
        }
        this.glasspane.revalidate();
        this.glasspane.repaint();
    }

    Component getContent() {
        return this.glasspane.getContent();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setModal(true);
            this.setUndecorated(true);
            this.glasspane.setVisible(true);
            this.updateDimension();
        }
        super.setVisible(visible);
    }

    private void updateDimension() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension dim = tk.getScreenSize();
        Insets margin = tk.getScreenInsets(this.getGraphicsConfiguration());
        dim.width -= margin.left + margin.right;
        dim.height -= margin.top + margin.bottom;
        this.setBounds(0, 0, dim.width, dim.height);
    }

    void updateBackgroundImage() {
        this.contentpane.updateBackgroundImage();
    }

    Component createComponentHolder(Component comp) {
        JInternalFrame iframe = new JInternalFrame();
        iframe.setFrameIcon(this.getFrameIcon());
        try {
            MouseMotionListener[] listeners;
            JComponent northpane = ((BasicInternalFrameUI)iframe.getUI()).getNorthPane();
            for (MouseMotionListener mml : listeners = northpane.getMouseMotionListeners()) {
                northpane.removeMouseMotionListener(mml);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        iframe.setContentPane((Container)comp);
        iframe.setVisible(true);
        return iframe;
    }

    private ImageIcon getFrameIcon() {
        if (this.frameIcon == null) {
            BufferedImage bi = new BufferedImage(1, 1, 2);
            Graphics2D g2 = bi.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1));
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            this.frameIcon = new ImageIcon(bi);
        }
        return this.frameIcon;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setListener(SubWindowListener listener) {
    }

    @Override
    public void closeWindow() {
        if (this.viewContext != null) {
            this.viewContext.close();
        }
        this.dispose();
        OSManager osm = OSManager.getInstance();
        osm.unregisterView(this.getName());
        osm.setScreenLock(null);
        this.glasspane.removeAll();
        this.contentpane.image = null;
    }

    @Override
    public void update(Map windowAttributes) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        OSManager osm = OSManager.getInstance();
        osm.setScreenLock(this);
        if (this.viewContext != null) {
            this.viewContext.display();
            this.viewContext.setSubWindow(this);
        }
        if (this.osview == null) {
            this.osview = new OSViewImpl();
            osm.registerView(this.getName(), this.osview);
        }
    }

    private class ContentPaneImpl
    extends JPanel {
        OSScreenLock root;
        private Image image;

        ContentPaneImpl() {
            this.root = OSScreenLock.this;
            this.root.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    ContentPaneImpl.this.root.repaint();
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    ContentPaneImpl.this.root.repaint();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    ContentPaneImpl.this.root.repaint();
                }
            });
            this.root.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    this.repaintImpl();
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.repaintImpl();
                }

                void repaintImpl() {
                    if (ContentPaneImpl.this.root.isVisible()) {
                        ContentPaneImpl.this.root.repaint();
                    }
                }
            });
        }

        void updateBackgroundImage() {
            try {
                Robot rbt = new Robot();
                Toolkit tk = Toolkit.getDefaultToolkit();
                Dimension dim = tk.getScreenSize();
                this.image = rbt.createScreenCapture(new Rectangle(0, 0, dim.width, dim.height));
            }
            catch (Throwable ex) {
                this.image = null;
                ex.printStackTrace();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            Point pos = this.getLocationOnScreen();
            Point offset = new Point(-pos.x, -pos.y);
            g.drawImage(this.image, offset.x, offset.y, null);
        }
    }

    private class OSViewImpl
    implements OSView {
        OSScreenLock root;

        private OSViewImpl() {
            this.root = OSScreenLock.this;
        }

        @Override
        public String getId() {
            return this.root.getName();
        }

        @Override
        public String getType() {
            return "screenlock";
        }

        @Override
        public void requestFocus() {
            Component comp = this.root.getContent();
            if (comp instanceof RootPaneContainer) {
                Container con = (Container)comp;
                con.requestFocus();
                con.setFocusCycleRoot(true);
                con.transferFocus();
            } else {
                this.root.requestFocus();
            }
        }

        @Override
        public void closeView() {
            this.root.closeWindow();
        }

        @Override
        public WindowContainer getWindowContainer() {
            return null;
        }
    }
}

