/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

class LCDWindowedCmdType {
    byte[] cmdBuffer;
    int cmdSize;
    int dataSize;
    static final int cmdOffset = 0;
    static final int modeOffset = 1;
    static final int xPosOffset = 2;
    static final int yPosOffset = 4;
    static final int xSizeOffset = 6;
    static final int ySizeOffset = 8;
    static final int dataOffset = 10;

    public LCDWindowedCmdType() {
        this.cmdSize = 10;
        this.dataSize = 0;
        this.cmdBuffer = new byte[this.cmdSize];
    }

    public LCDWindowedCmdType(int size) {
        this.cmdSize = size + 10;
        this.dataSize = size;
        this.cmdBuffer = new byte[this.cmdSize];
    }

    void setCmd(byte cmd) {
        this.cmdBuffer[0] = cmd;
    }

    byte getCmd() {
        return this.cmdBuffer[0];
    }

    void setMode(int mode) {
        this.cmdBuffer[1] = (byte)mode;
    }

    void setXPos(int xPos) {
        this.cmdBuffer[2] = (byte)(xPos >> 8 & 0xFF);
        this.cmdBuffer[3] = (byte)(xPos & 0xFF);
    }

    void setYPos(int yPos) {
        this.cmdBuffer[4] = (byte)(yPos >> 8 & 0xFF);
        this.cmdBuffer[5] = (byte)(yPos & 0xFF);
    }

    void setXSize(int xSize) {
        this.cmdBuffer[6] = (byte)(xSize >> 8 & 0xFF);
        this.cmdBuffer[7] = (byte)(xSize & 0xFF);
    }

    void setYSize(int ySize) {
        this.cmdBuffer[8] = (byte)(ySize >> 8 & 0xFF);
        this.cmdBuffer[9] = (byte)(ySize & 0xFF);
    }

    void setData(byte[] data) {
        if (data.length > this.dataSize) {
            return;
        }
        int i = 0;
        while (i < data.length) {
            this.cmdBuffer[10 + i] = data[i];
            ++i;
        }
    }

    void dump() {
        int i = 0;
        while (i < this.cmdSize) {
            int v = this.cmdBuffer[i];
            System.out.println("LCDCmd: Byte[ " + i + " ] = " + (v &= 0xFF));
            ++i;
        }
    }
}

