/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.LCDGraphicBitmapType;
import com.topaz.sigplus.util.TabletInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class LCDGraphicsSupport {
    TabletInterface tab;

    public LCDGraphicsSupport(TabletInterface tabIf) {
        this.tab = tabIf;
    }

    public boolean lcdWriteImage(int dest, int mode, int xPos, int yPos, int xSize, int ySize, BufferedImage imageData) {
        LCDGraphicBitmapType gmp = new LCDGraphicBitmapType();
        if (mode != 0 && mode != 1) {
            if (imageData != null) {
                if (xSize == 0) {
                    xSize = imageData.getWidth();
                }
                if (ySize == 0) {
                    ySize = imageData.getHeight();
                }
                gmp.init(xPos, yPos, xSize, ySize);
                int i = 0;
                while (i < xSize) {
                    int j = 0;
                    while (j < ySize) {
                        int pixel = imageData.getRGB(i, j);
                        gmp.setPixel(i, j, pixel);
                        ++j;
                    }
                    ++i;
                }
            } else {
                xSize = 16;
                ySize = 16;
                xPos = 0;
                yPos = 0;
                gmp.init(xPos, yPos, xSize, ySize);
                int i = 0;
                while (i < gmp.bufferSize) {
                    gmp.buffer[i] = -1;
                    ++i;
                }
            }
        } else {
            gmp.init(xPos, yPos, xSize, ySize);
            gmp.bufferSize = 0;
        }
        boolean oldStatus = this.tab.tabletStatus;
        if (!oldStatus) {
            this.tab.openTablet();
        }
        boolean rv = this.tab.lcdSendGraphic(dest, mode, gmp.xPosNew, yPos, gmp.xSizeNew, ySize, gmp.buffer, gmp.bufferSize, gmp.pixelDepth);
        this.tab.lcdTabletSetup();
        if (!oldStatus) {
            this.tab.closeTablet();
        }
        return rv;
    }

    public void lcdWriteString(int dest, int mode, int xpos, int ypos, String text, Font typeFace) {
        BufferedImage textImage = new BufferedImage(this.tab.params.getTabletLCDXSize(), this.tab.params.getTabletLCDYSize(), 5);
        Graphics textGraph = textImage.getGraphics();
        if (textGraph != null) {
            try {
                textGraph.setFont(typeFace);
                textGraph.setColor(Color.white);
                textGraph.fillRect(0, 0, this.tab.params.getTabletLCDXSize(), this.tab.params.getTabletLCDYSize());
                textGraph.setColor(Color.black);
                FontMetrics fm = textGraph.getFontMetrics();
                int ys = fm.getHeight();
                int xs = fm.stringWidth(text);
                textGraph.drawString(text, 0, ys - 1 - fm.getDescent());
                this.lcdWriteImage(dest, mode, xpos, ypos, xs, ys, textImage);
            }
            finally {
                textGraph.dispose();
            }
        }
    }

    public boolean lcdWriteImage(int dest, int mode, int xPos, int yPos, int xSize, int ySize, BufferedImage imageData, int pixelDepth) {
        LCDGraphicBitmapType gmp = new LCDGraphicBitmapType();
        if (mode != 0 && mode != 1) {
            if (imageData != null) {
                if (xSize == 0) {
                    xSize = imageData.getWidth();
                }
                if (ySize == 0) {
                    ySize = imageData.getHeight();
                }
                gmp.init(xPos, yPos, xSize, ySize, pixelDepth);
                int i = 0;
                while (i < xSize) {
                    int j = 0;
                    while (j < ySize) {
                        int pixel = imageData.getRGB(i, j);
                        gmp.setPixel(i, j, pixel);
                        ++j;
                    }
                    ++i;
                }
            } else {
                xSize = 16;
                ySize = 16;
                xPos = 0;
                yPos = 0;
                gmp.init(xPos, yPos, xSize, ySize);
                int i = 0;
                while (i < gmp.bufferSize) {
                    gmp.buffer[i] = -1;
                    ++i;
                }
            }
        } else {
            gmp.init(xPos, yPos, xSize, ySize);
            gmp.bufferSize = 0;
        }
        boolean oldStatus = this.tab.tabletStatus;
        if (!oldStatus) {
            this.tab.openTablet();
        }
        boolean rv = this.tab.lcdSendGraphic(dest, mode, gmp.xPosNew, yPos, gmp.xSizeNew, ySize, gmp.buffer, gmp.bufferSize, gmp.pixelDepth);
        this.tab.lcdTabletSetup();
        if (!oldStatus) {
            this.tab.closeTablet();
        }
        return rv;
    }
}

